﻿// iANPR2Client.cpp : Этот файл содержит функцию "main". Здесь начинается и заканчивается выполнение программы.
//

#include <iostream>
#include <fstream>
//#include <opencv2/opencv.hpp>
#include "../httplib.h"

using namespace std;

void runClient(int port)
{
    httplib::Client cli("localhost", port);    
    ifstream in("image2.jpg", std::ios::binary);
    // Читаем всё в массив
    std::vector<char> buffer(std::istreambuf_iterator<char>(in), {});
    in.close();
    
    httplib::MultipartFormDataItems items = {
        { "image", std::string(buffer.data(), buffer.size()), "image", "application/octet-stream" },
    };
    for (;;)
    {
        if (auto res = cli.Post("/ImageInference", items)) {            
            cout << res->status << endl;
            cout << res->get_header_value("Content-Type") << endl;
            cout << res->body << endl;
        }
        else {
            cout << "error code: " << res.error() << std::endl;
        }
    }
}

void printHelp()
{
    cout << "(C) 2024. IntBuSoft. iANPR2Client - client for iANPR2 Inference Server\nRun:\n";
    cout << " -p   - port of server: iANPR2Client.exe -p <port>\n";
}

int main(int argc, char* argv[])
{
    if (argc == 1)
    {
        printHelp();
        return 0;
    }

    vector<string> arg;
    for (int i = 0; i < argc - 1; i++)
        arg.push_back(argv[i + 1]);

    if (arg[0] == "-p" && arg.size() == 2)
    {
        runClient(stoi(arg[1]));
        return 0;
    }

    printHelp();

    return 0;
}

