#pragma once
#include <string>  
#include <vector>

const int maxImages = 1000;
const int maxGPUObjects = 16;

struct ConfigSetting
{
	int versionIIS;
	int maxImagesInQueue;
	std::string pathToConfigForLibrary;
	float detectConfThresh = 0.25;
	int minPlateHeight = 12;
	int minPlateWidth = 60;
	std::vector<std::string> plateTemplates;
	int minSymbolsPlate = 6;
	int maxSymbolsPlate = 15;
	unsigned int gpuObjects = 1;
	int mode = 0; // 0 - , 1 - 
	int port = 8080;
	int expandedResult; // 0 -  , 1 - 
};

bool loadConfig(std::string path, ConfigSetting& res);
