// iANPR2.h  -   iANPR2 SDK
#pragma once
#include <opencv2/opencv.hpp>
#include <vector>

typedef void* iANPR2Object;
typedef void* iANPR2TrajectoryObject;

//    
#define iANPR2_RESULT_NUMBER_FULL		0	//    ,     ,  &0000,  0000 -   UTF-16
											//          -      
#define iANPR2_RESULT_NUMBER_UTF8		1	//    UTF-8
#define iANPR2_RESULT_NUMBER_1251		2	//    Windows-1251
#define iANPR2_RESULT_NUMBER_LATIN		3	//    ,    '?'

//  
struct iANPR2Setting
{
	float detectConfThresh = 0.25f; //    ( 0.25)   (0,1)
	int minPlateHeight = 12;        //     ,   .  12
	int minPlateWidth = 50;         //     ,   .  50
	std::vector<std::string>
		templateCountries;          //  
	// bool parallelCPUfunc = false;    2.6
	bool turnNumber = true;			//    2.6.  ,   
	int memoryNumberFrames = 4;     //       
	int memoryNumberRepeat = 2;	    //        
	int minSymbolsPlate = 6;        //     
	int maxSymbolsPlate = 15;       //     
	bool mem = false;               //    
	bool expandedResult = false;	//  ,        	
	int typeResultNumberStr =
		iANPR2_RESULT_NUMBER_LATIN;	//    2.6.    
};

// ,   
struct NumberResult
{
	cv::Rect rect;						//   
	std::vector<std::string> strings;   //  -  
	std::vector<std::string> templates; //  -  
	std::vector<std::string> zones;		//  -  .    ,   
	std::vector<float> confidence;		//  
	float score;						//    
};

// ,    -  
struct ObjectResult
{
	cv::Rect rect;						//   
	float score;						//   
	int classId;						//    
	int indexNum;						//    ,   . -1 -  
};

// ,    
struct NumberResultMem
{
	std::string numberString;
	std::string numberTemplate;
	std::string numberZone;
};

// ,    
struct PointTrajectory
{
	cv::Point point;							//    (   )
	unsigned long weight;						//   -     
	long time;									//       
};

//     
struct TrajectoryResult
{
	std::vector<PointTrajectory> points;		//    
	std::string strNumber;						//  
	std::string templateNumber;					//  		
	std::string zone;							// 
	unsigned long weights;						//   
	unsigned long ID;							// ID 
};

/*
*       
*/
extern "C" bool iANPR2Version(char* outBuf, int sizeBuf);


/* 
*   iANPR2
* :
*   configFile -  json ;
*   license -  ;
*   error -  
*   iANPR2Object
*/
extern "C" iANPR2Object iANPR2Init(char* configFile, char*license, int* error);

/*
*   iANPR2
* :
*   detectionModelPath -    ;
*   batchSize -    ;
*   symbolsDetectModelPath -     ;
*   classificationModelPath -     ;
*   plateTemplatesStringInJSON - ,  JSON  ;
*   license -  ;
*   error -  
*   iANPR2Object
*/

extern "C" iANPR2Object iANPR2Init2(char* detectionModelPath, int batchSize, char* symbolsDetectModelPath, char* classificationModelPath,
	char* plateTemplatesStringInJSON, char* license, int* error);

/* 
*   iANPR2
* :
*   object -   iANPR2Object
*/
extern "C" void iANPR2Release(iANPR2Object* object);

/* 
*   iANPR2 -  2
* :
*   object - iANPR2Object
*  true,  . False -  
*/
extern "C" bool iANPR2ReleaseP(iANPR2Object object);

/* 
*   
* :
*   object - iANPR2Object;
*   settings -   iANPR2Setting
*  true,  . False -  
*/
extern "C" bool iANPR2Settings(iANPR2Object object, iANPR2Setting settings);

/* 
*       JSON
* :
*   object - iANPR2Object;
*   json -   iANPR2Setting,   JSON
*  true,  . False -  
*/
extern "C" bool iANPR2SettingsJSON(iANPR2Object object, char* json);

/* 
*     
* :
*   object - iANPR2Object;
*   images -  
*  0,  .  -  .
*/
extern "C" int anpr2PLate(iANPR2Object object, std::vector<cv::Mat> images);

/* 
*    -   BMP, JPEG, PNG  TIFF
* :
*   object - iANPR2Object;
*   imageBytes -  ,   BMP, JPEG, PNG  TIFF;
*   sizeImage -  
*  0,  .  -  .
*/
extern "C" int anpr2AddImage(iANPR2Object object, const char* imageBytes, long sizeImage);

/* 
*   anpr2AddImage 
* :
*   object - iANPR2Object
*  0,  .  -  .
*/
extern "C" int anpr2inference(iANPR2Object object);

/* 
*   
* :
*   object - iANPR2Object
*    NumberResult   .
*/
std::vector<std::vector<NumberResult>> anpr2GetResult(iANPR2Object object);

/* 
*     
* :
*   object - iANPR2Object
*    ObjectResult   .
*/
std::vector<std::vector<ObjectResult>> anpr2GetAddResult(iANPR2Object object);

/* 
*      JSON
* :
*   object - iANPR2Object
*   outBuf -    JSON;
*   sizeBuf -   .
*  0      JSON          . - 1
*  object ,   IA_OUTJSONBUFFERSMALL -    
*/
extern "C" int anpr2GetResultJSON(iANPR2Object object, char* outBuf,int sizeBuf);

/*
*       JSON
* :
*   object - iANPR2Object
*   outBuf -    JSON;
*   sizeBuf -   .
*  0      JSON          . - 1
*  object ,   IA_OUTJSONBUFFERSMALL -    
*/
extern "C" int anpr2GetAddResultJSON(iANPR2Object object, char* outBuf, int sizeBuf);

/* 
*     
* :
*   object - iANPR2Object;
*    NumberResultMem   .
*/
std::vector<std::vector<NumberResultMem>> anpr2GetResultMem(iANPR2Object object);

/* 
*        JSON
* :
*   object - iANPR2Object
*   outBuf -    JSON;
*   sizeBuf -   .
*  0      JSON          . - 1
*  object ,   IA_OUTJSONBUFFERSMALL -    
*/
extern "C" int anpr2GetResultMemJSON(iANPR2Object object, char* outBuf,int sizeBuf);

/*
*     
* :
*   widthImage -    
*   heightImage -    
*   tLimitTime -    ( ),  10000
*   tLimitFrames -    ,  100
*   typeSpeed -    . 0 -  , 1 -  
*/
extern "C" iANPR2TrajectoryObject iANPR2Trajectory(int widthImage, int heightImage, int tLimitTime, int tLimitFrames, int typeSpeed);

/* 
*   
* :
*   object - iANPR2TrajectoryObject
*  true,  . False -  
*/
extern "C" bool iANPR2TrajectoryRelease(iANPR2TrajectoryObject object);

/* 
*      
* :
*   object - iANPR2TrajectoryObject
*   numbers -  
*   objects -   
*  true,  . False -  
*/
bool iANPR2TrajectoryProcess(iANPR2TrajectoryObject object, std::vector<NumberResult> numbers, 
	std::vector<ObjectResult> objects);

/*
*         JSON
* :
*   object - iANPR2TrajectoryObject
*   jsonNumbers -     JSON,  anpr2GetResultJSON
*   jsonObjects -      JSON,  anpr2GetAddResultJSON
*  true,  . False -  
*/
extern "C" bool iANPR2TrajectoryProcessJSON(iANPR2TrajectoryObject object, char* jsonNumbers, char* jsonObjects);

/* 
*   
* :
*   object - iANPR2TrajectoryObject
*   
*/
std::vector<TrajectoryResult> iANPR2TrajectoryGetResult(iANPR2TrajectoryObject object);

/*
*      JSON
* :
*   object - iANPR2TrajectoryObject
*   outBuf -    JSON;
*   sizeBuf -   .
*  0      JSON          . - 1
*  object ,   IA_OUTJSONBUFFERSMALL -    
*/
extern "C" int iANPR2TrajectoryGetResultJSON(iANPR2TrajectoryObject object, char* outBuf, int sizeBuf);

/*
*     
*          - line1  line2
*     ,   (    .
* :
*   object - iANPR2TrajectoryObject
*   line1X1 - X  1  1 
*   line1Y1 - Y  1  1 
*   line1X2 - X  2  1 
*   line1Y2 - Y  2  1 
*   line2X1 - X  1  2 
*   line2Y1 - Y  1  2 
*   line2X2 - X  2  2 
*   line2Y2 - Y  2  2 
*  0  .
*/
extern "C" int iANPR2CreateLineIntersection(iANPR2TrajectoryObject object,
	int line1X1, int line1Y1, int line1X2, int line1Y2,
	int line2X1, int line2Y1, int line2X2, int line2Y2);

/*
*         
*         iANPR2TrajectoryGetResult  iANPR2TrajectoryGetResultJSON
* :
*   object - iANPR2TrajectoryObject
*   indexTr -  
*   0 -  , 1 -  -, 2 -  , -1      
*/
extern "C" int iANPR2GetLineIntersection(iANPR2TrajectoryObject object, int indexTr);

/*
*       
* :
*   object - iANPR2Object
*   indexStream -  
*   0   .
*/
extern "C" int anpr2SetMemStream(iANPR2Object object, int indexStream);