from http.server import BaseHTTPRequestHandler, HTTPServer
from urllib.parse import urlparse, parse_qs
import cgi
import os

class SimpleHTTPRequestHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        # Обработка GET-запросов (как в предыдущем примере)
        parsed_url = urlparse(self.path)
        query_params = parse_qs(parsed_url.query)

        stream = query_params.get('stream', [None])[0]
        dr = query_params.get('dr', [None])[0]
        date = query_params.get('date', [None])[0]
        plate = query_params.get('plate', [None])[0]

        response = f"GET request received\nStream: {stream}\nDR: {dr}\nDate: {date}\nPlate: {plate}\n"

        self.send_response(200)
        self.send_header('Content-type', 'text/plain')
        self.end_headers()
        self.wfile.write(response.encode('utf-8'))

    def do_POST(self):
        # Обработка POST-запросов
        content_type = self.headers['Content-Type']
        
        # Проверяем, что это multipart/form-data
        if not content_type or 'multipart/form-data' not in content_type:
            self.send_response(400)
            self.end_headers()
            self.wfile.write(b'Invalid Content-Type. Expected multipart/form-data')
            return

        # Парсим multipart/form-data
        form = cgi.FieldStorage(
            fp=self.rfile,
            headers=self.headers,
            environ={'REQUEST_METHOD': 'POST'}
        )

        # Получаем текстовое сообщение
        message = form.getvalue('message', '')
        print(message)
        
        # Получаем файл изображения
        if form.getvalue('image') is not None:
            image_item = form['image']
            if image_item.filename:
                # Сохраняем изображение
                with open('image.jpg', 'wb') as f:
                    f.write(image_item.file.read())
                image_status = f"Image saved as image.jpg ({os.path.getsize('image.jpg')} bytes)"
            else:
                image_status = "No image received"
		
        if form.getvalue('smallImage') is not None:		
            image_item = form['smallImage']
            if image_item.filename:
                # Сохраняем изображение
                with open('smallImage.jpg', 'wb') as f:
                    f.write(image_item.file.read())
                image_status = f"Image saved as smallImage.jpg ({os.path.getsize('smallImage.jpg')} bytes)"
            else:
                image_status = "No image received"			

        if form.getvalue('plateImage') is not None:			
            image_item = form['plateImage']
            if image_item.filename:
                # Сохраняем изображение
                with open('plateImage.jpg', 'wb') as f:
                    f.write(image_item.file.read())
                image_status = f"Image saved as plateImage.jpg ({os.path.getsize('plateImage.jpg')} bytes)"
            else:
                image_status = "No image received"		

        if form.getvalue('carImage') is not None:			
            image_item = form['carImage']
            if image_item.filename:
                # Сохраняем изображение
                with open('carImage.jpg', 'wb') as f:
                    f.write(image_item.file.read())
                image_status = f"Image saved as carImage.jpg ({os.path.getsize('carImage.jpg')} bytes)"
            else:
                image_status = "No image received"				

        # Формируем ответ
        response = f"POST request received\nMessage: {message}\n{image_status}\n"

        self.send_response(200)
        self.send_header('Content-type', 'text/plain')
        self.end_headers()
        self.wfile.write(response.encode('utf-8'))
		
    def do_PUT(self):
        # Обработка PUT-запросов
        content_type = self.headers['Content-Type']
        
        # Проверяем, что это multipart/form-data
        if not content_type or 'multipart/form-data' not in content_type:
            self.send_response(400)
            self.end_headers()
            self.wfile.write(b'Invalid Content-Type. Expected multipart/form-data')
            return

        # Парсим multipart/form-data
        form = cgi.FieldStorage(
            fp=self.rfile,
            headers=self.headers,
            environ={'REQUEST_METHOD': 'POST'}
        )

        # Получаем текстовое сообщение
        message = form.getvalue('message', '')
        print(message)		
        # Формируем ответ
        response = f"PUT request received\nMessage: {message}\n"

        self.send_response(200)
        self.send_header('Content-type', 'text/plain')
        self.end_headers()
        self.wfile.write(response.encode('utf-8'))		

def run(server_class=HTTPServer, handler_class=SimpleHTTPRequestHandler, port=8000):
    server_address = ('', port)
    httpd = server_class(server_address, handler_class)
    print(f'Starting httpd server on port {port}...')
    httpd.serve_forever()

if __name__ == '__main__':
    run()